/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev.ui;

import frc.emul.config.data.DevOptions;
import frc.emul.psg.dev.ui.AbstractChannelAccessor;
import frc.emul.psg.dev.ui.IChannelAccessor;
import frc.emul.psg.dev.ui.IChannelsMonitor;
import frc.emul.psg.dev.ui.SamplesProcessor;
import java.awt.Color;
import java.awt.Component;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public abstract class JoglChannelsMonitor
implements GLEventListener,
IChannelsMonitor {
    private static final Color COL_MAX = new Color(0.0f, 0.0f, 0.4f);
    private static final Color COL_AVG_MIXED = new Color(1.0f, 1.0f, 0.0f);
    private static final Color COL_AVG_CHANNEL = new Color(1.0f, 1.0f, 1.0f);
    private static final float LINE_WIDTH_NORM = 1.25f;
    private static final float LINE_WIDTH_MAX = 0.9f;
    private static final float LINE_WIDTH_GRID = 1.0f;
    private static final double XSCALE = 0.99;
    private static final double YSCALE = 0.975;
    private final IChannelAccessor[] channels;
    private final SamplesProcessor processor;
    private final GLCanvas canvas;
    private final GLU glu = new GLU();
    private int zoomed;

    public JoglChannelsMonitor(final SamplesProcessor samplesProcessor) {
        this.processor = samplesProcessor;
        this.channels = new IChannelAccessor[]{new AbstractChannelAccessor(samplesProcessor, COL_AVG_MIXED, COL_MAX){

            public boolean paintMaximum() {
                return JoglChannelsMonitor.this.paintMaxSamples();
            }

            public int[] getSamplesAverage() {
                return samplesProcessor.listABC;
            }

            public int[] getSamplesMaximum() {
                return samplesProcessor.lMaxABC;
            }
        }, new AbstractChannelAccessor(samplesProcessor, COL_AVG_CHANNEL, COL_MAX){

            public boolean paintMaximum() {
                return JoglChannelsMonitor.this.paintMaxSamples();
            }

            public int[] getSamplesAverage() {
                return samplesProcessor.listA;
            }

            public int[] getSamplesMaximum() {
                return samplesProcessor.lMaxA;
            }
        }, new AbstractChannelAccessor(samplesProcessor, COL_AVG_CHANNEL, COL_MAX){

            public boolean paintMaximum() {
                return JoglChannelsMonitor.this.paintMaxSamples();
            }

            public int[] getSamplesAverage() {
                return samplesProcessor.listB;
            }

            public int[] getSamplesMaximum() {
                return samplesProcessor.lMaxB;
            }
        }, new AbstractChannelAccessor(samplesProcessor, COL_AVG_CHANNEL, COL_MAX){

            public boolean paintMaximum() {
                return JoglChannelsMonitor.this.paintMaxSamples();
            }

            public int[] getSamplesAverage() {
                return samplesProcessor.listC;
            }

            public int[] getSamplesMaximum() {
                return samplesProcessor.lMaxC;
            }
        }};
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setDepthBits(8);
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.addGLEventListener((GLEventListener)this);
    }

    protected boolean paintMaxSamples() {
        return true;
    }

    public Component getDisplayComponent() {
        return this.canvas;
    }

    public void updateDisplay() {
        this.canvas.repaint();
    }

    public void setZoomedChannel(IChannelsMonitor.Channel channel) {
        int n = this.zoomed;
        switch (channel) {
            case CHANNEL_MIX: {
                this.zoomed = 1;
                break;
            }
            case CHANNEL_A: {
                this.zoomed = 2;
                break;
            }
            case CHANNEL_B: {
                this.zoomed = 3;
                break;
            }
            case CHANNEL_C: {
                this.zoomed = 4;
                break;
            }
            default: {
                this.zoomed = 0;
            }
        }
        if (this.zoomed != n) {
            this.updateDisplay();
        }
    }

    public IChannelsMonitor.Channel getZoomedChannel() {
        switch (this.zoomed) {
            case 1: {
                return IChannelsMonitor.Channel.CHANNEL_MIX;
            }
            case 2: {
                return IChannelsMonitor.Channel.CHANNEL_A;
            }
            case 3: {
                return IChannelsMonitor.Channel.CHANNEL_B;
            }
            case 4: {
                return IChannelsMonitor.Channel.CHANNEL_C;
            }
        }
        return IChannelsMonitor.Channel.CHANNEL_NONE;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        boolean bl = DevOptions.useAntiAliasingInDebugTools;
        GL gL = gLAutoDrawable.getGL();
        gL.glDisable(3552);
        gL.glDisable(3553);
        gL.glDisable(32879);
        gL.glDisable(2896);
        gL.glDisable(2884);
        gL.glDisable(2929);
        gL.glDepthMask(false);
        if (bl) {
            gL.glHint(3154, 4354);
            gL.glEnable(2848);
            gL.glBlendFunc(770, 771);
            gL.glEnable(3042);
        } else {
            gL.glDisable(2848);
            gL.glDisable(3042);
        }
        gL.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16384);
        gL.glLoadIdentity();
        int n = this.channels.length;
        if (this.zoomed == 0) {
            gL.glScalef(1.0f, 1.0f / (float)n, 1.0f);
            gL.glTranslatef(0.0f, (float)(n + 1), 0.0f);
            int n2 = 0;
            while (n2 < n) {
                gL.glTranslatef(0.0f, -2.0f, 0.0f);
                gL.glPushMatrix();
                SamplesProcessor samplesProcessor = this.processor;
                synchronized (samplesProcessor) {
                    JoglChannelsMonitor.render(gL, this.channels[n2]);
                }
                gL.glPopMatrix();
                ++n2;
            }
        } else {
            gL.glScaled(1.0, 1.0075, 1.0);
            SamplesProcessor samplesProcessor = this.processor;
            synchronized (samplesProcessor) {
                JoglChannelsMonitor.render(gL, this.channels[this.zoomed - 1]);
            }
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        gL.glViewport(n, n2, n3, n4);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(-1.0, 1.001, -1.0, 1.001);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public static final void render(GL gL, IChannelAccessor iChannelAccessor) {
        int n;
        gL.glScaled(0.99, 0.975, 1.0);
        gL.glColor3f(0.3f, 0.3f, 0.3f);
        gL.glLineWidth(0.5f);
        gL.glBegin(1);
        gL.glVertex2f(-1.0f, 0.0f);
        gL.glVertex2f(1.0f, 0.0f);
        gL.glEnd();
        gL.glLineWidth(1.0f);
        gL.glBegin(2);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
        SamplesProcessor samplesProcessor = iChannelAccessor.getProcessor();
        if (samplesProcessor.isMute()) {
            return;
        }
        boolean bl = samplesProcessor.full;
        int n2 = samplesProcessor.getHistorySize();
        int n3 = samplesProcessor.writeIdx;
        int n4 = n = bl ? n3 : 0;
        if (!bl && n3 - n < 10) {
            return;
        }
        float f = 2.0f / (float)n2;
        float f2 = 6.103702E-5f;
        gL.glTranslatef(0.0f, -1.0f, 0.0f);
        if (iChannelAccessor.paintMaximum()) {
            gL.glLineWidth(0.9f);
            JoglChannelsMonitor.setColor(gL, iChannelAccessor.getColorMaximum());
            JoglChannelsMonitor.drawData(gL, iChannelAccessor.getSamplesMaximum(), n, n3, n2, f, f2);
        }
        if (iChannelAccessor.paintAverage()) {
            gL.glLineWidth(1.25f);
            JoglChannelsMonitor.setColor(gL, iChannelAccessor.getColorAverage());
            JoglChannelsMonitor.drawData(gL, iChannelAccessor.getSamplesAverage(), n, n3, n2, f, f2);
        }
    }

    private static final void drawData(GL gL, int[] nArray, int n, int n2, int n3, float f, float f2) {
        gL.glBegin(3);
        float f3 = -1.0f + 0.5f * f;
        float f4 = (float)nArray[n++] * f2;
        gL.glVertex2f(f3, f4);
        while (n2 != (n %= n3)) {
            f4 = (float)nArray[n++] * f2;
            gL.glVertex2f(f3 += f, f4);
        }
        gL.glEnd();
    }

    public static final void setColor(GL gL, Color color) {
        gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }
}

